﻿using System;
using DotNetCore.CAP;
using DotNetCore.CAP.Kafka;

namespace Microsoft.Extensions.DependencyInjection
{
    public static class CapOptionsExtensions
    {
        public static CapOptions UseKafka(this CapOptions options, string bootstrapServers)
        {
            return options.UseRabbitMQ(opt =>
            {
                opt.Servers = bootstrapServers;
            });
        }

        public static CapOptions UseRabbitMQ(this CapOptions options, Action<KafkaOptions> configure)
        {
            if (configure == null) throw new ArgumentNullException(nameof(configure));

            options.RegisterExtension(new KafkaCapOptionsExtension(configure));

            return options;
        }
    }
}