# CAP
[![Travis branch](https://img.shields.io/travis/dotnetcore/CAP/master.svg?label=travis-ci)](https://travis-ci.org/dotnetcore/CAP)
[![AppVeyor](https://ci.appveyor.com/api/projects/status/4mpe0tbu7n126vyw?svg=true)](https://ci.appveyor.com/project/yuleyule66/cap)
[![NuGet](https://img.shields.io/nuget/vpre/DotNetCore.CAP.svg)](https://www.nuget.org/packages/DotNetCore.CAP/)
[![GitHub license](https://img.shields.io/badge/license-MIT-blue.svg)](https://raw.githubusercontent.com/dotnetcore/CAP/master/LICENSE.txt)

CAP һڷֲʽϵͳSOAMicroServiceʵһԵĿ⣬ʹáܵص㡣

## ԤOverView

CAP һ ASP.NET Core ĿʹõĿ⣬Ȼ ASP.NET Core On .NET Framework С

԰ CAP һ EventBusΪ EventBus йܣCAPṩ˸Ӽ򻯵ķʽ EventBus еķͶġ

CAP Ϣ־ûĹܣķ崻ʱԱ֤ϢĿɿԡCAPṩ˻Microsoft DI  Producer Service Ժҵ޷ϣ֧ǿһԵ

CAPASP.NET Core ΢ܹеһʾͼ

![](http://images2015.cnblogs.com/blog/250417/201706/250417-20170630143600289-1065294295.png)

> ͼʵִ߲û룬ִ߲CAPڲʵ֡

## Getting Started

### NuGet  δ

Ŀаװ CAP

Ϣʹõ Kafka Ļԣ

```
PM> Install-Package DotNetCore.CAP.Kafka
```

Ϣʹõ RabbitMQ Ļԣ

```
PM> Install-Package DotNetCore.CAP.RabbitMQ
```

CAP Ĭṩ Entity Framwork Ϊݿ洢

```
PM> Install-Package DotNetCore.CAP.EntityFrameworkCore
```

### Configuration

CAP Startup.cs ļУ£

```cs
public void ConfigureServices(IServiceCollection services)
{
	......

    services.AddDbContext<AppDbContext>();

    services.AddCap()
            .AddEntityFrameworkStores<AppDbContext>()
            .AddKafka(x => x.Servers = "localhost:9453");
}

public void Configure(IApplicationBuilder app)
{
	.....

    app.UseCap();
}

```

### 

 Controller ע `ICapProducerService` Ȼʹ `ICapProducerService` Ϣ

```cs
public class PublishController : Controller
{
	private readonly ICapProducerService _producer;

	public PublishController(ICapProducerService producer)
	{
		_producer = producer;
	}


	[Route("~/checkAccount")]
	public async Task<IActionResult> PublishMessage()
	{
		//ָ͵Ϣͷ
		await _producer.SendAsync("xxx.services.account.check", new Person { Name = "Foo", Age = 11 });

		return Ok();
	}
}

```

### 

**Action Method**

Action Attribute Ϣ

ʹõ Kafak ʹ `[KafkaTopic()]`,  RabbitMQ ʹ `[RabbitMQTopic()]`

```cs
public class PublishController : Controller
{
	private readonly ICapProducerService _producer;

	public PublishController(ICapProducerService producer)
	{
		_producer = producer;
	}


	[NoAction]
	[KafkaTopic("xxx.services.account.check")]
	public async Task CheckReceivedMessage(Person person)
	{
		Console.WriteLine(person.Name);
		Console.WriteLine(person.Age);     
		return Task.CompletedTask;
	}
}

```

**Service Method**

Ķķûλ Controller У㶩ĵҪ̳ `IConsumerService`

```cs

namespace xxx.Service
{
	public interface ISubscriberService
	{
		public void CheckReceivedMessage(Person person);
	}


	public class SubscriberService: ISubscriberService, IConsumerService
	{
		[KafkaTopic("xxx.services.account.check")]
		public void CheckReceivedMessage(Person person)
		{
			
		}
	}
}

```

Ȼ Startup.cs е `ConfigureServices()` ע  `ISubscriberService` 

```cs
public void ConfigureServices(IServiceCollection services)
{
	services.AddTransient<ISubscriberService,SubscriberService>();
}
```

## 

׵򵥵ķ֮һǲۺ⣨issueҲͨύ Pull Request ס

### License

MIT
