/*
 * Licensed to the OpenSkywalking under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The OpenSkywalking licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

using System.Collections.Generic;
using Microsoft.Extensions.CommandLineUtils;

namespace SkyWalking.DotNet.CLI
{
    public class AppCommandResolver: IAppCommandResolver
    {
        private readonly IEnumerable<IAppCommand> _appCommands;

        public AppCommandResolver(IEnumerable<IAppCommand> appCommands)
        {
            _appCommands = appCommands;
        }
        
        public void Resolve(CommandLineApplication application)
        {
            foreach (var command in _appCommands)
            {
                application.Command(command.Name, command.Execute);
            }
        }
    }
}