# IMPLEMENTATION
Users can get a ICapPublisher interface from the ASP.NET Core DI container to publish a message .It is initialized by  configurations in the `ConfigureServices` and `configure` method in the Startup.cs file,just like the way to initialize a `MiddleWare` in ASP.NET Core.

## Message Table

After initialized, CAP will create two tables in the client side,they are `Cap.Published` and `Cap.Received`. Please noted that different databases may deal letter case differently,if you do not explicitly specify the Schema or the TableName Prefix before project startup,the default names are the ones mentioned above.

**Cap.Published**：Used to store  messages(Published by the `ICapPublisher` service) that CAP published to the MQ(Message Queue)Client side

**Cap.Received**:Used to Store messages(subscribed by the `CapSubscribe[]`) subscribed by the MQ(message Queue) client side that CAP received.

Both `Published` and `Received` tables have a `StatusName` field,which is used to mark the status of the current message.Until now it has `Scheduled`，`Successed` and `Failed` statuses.

In the process of dealing with messages,CAP will change the status from `Scheduled` to `Successed`(or `Failed` ).if the final status is `Successed`,it means that the message is sent to MQ successfully,and `Failed` means the message is failed to sent to MQ.

Version later than 2.2,  CAP will retry after 4 minutes if the status is `Scheduled` or `Failed`,the retry interval is default to 60 seconds.You can change it by modify `FailedRetryInterval` in `CapOptions`.

## Message format

CAP use JSON to transfer message,the following is CAP's messaging object model:

NAME | DESCRIPTION | TYPE
:---|:---|:---
Id | Message Id | int
Version | Message Version | string
Name | Name | string
Content | Content | string
Group | Group a message belongs to | string
Added |add time | DateTime
ExpiresAt | expire time | DateTime
Retries | retry times | int
StatusName | Status Name | string

>for `Cap.Received`,there is an extra `Group` filed to mark which group the mesage belongs to.

>for the `Content` property CAP will use a Messsage object to wrap all the contents.The following shows details of the Message Object:


NAME | DESCRIPTION | TYPE
:---|:---|:---
Id | Generated by CAP | string 
Timestamp | message create time | string
Content | content | string
CallbackName | the subscriber which is used to call back | string

CAP use the same algorithms as MongoDB ObjectId's distributed Id  generation algorithms.

## EventBus 

EventBus adopt the publish-subscribe messaging style to communicate with different components,and there is no need to register it in component explicitly.

![](http://images2017.cnblogs.com/blog/250417/201708/250417-20170804153901240-1774287236.png)

the diagram in the above link shows Eventbus's event flowchart,about EventBus,users can refer to other meterials to learn about it.

We say that CAP implement all the features in Eventbus,EventBus has two features:publish and subscribe,In CAP we implement them in an elegant way.Besides,CAP also has two very robust feature,they are message persistence and messaging reliability under any circumstances,But EventBus don't have such features.


![](https://camo.githubusercontent.com/452505edb71d41f2c1bd18907275b76291621e46/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3235303431372f3230313730372f3235303431372d32303137303730353137353832373132382d313230333239313436392e706e67)

In CAP,send a message can be regarded as an "Event",When CAP is used in an ASP.NET Core applicaiton,the application has the ablity to publish as well as receive messages.

## Retry

Retry plays a very important role in CAP's infrastructure,CAP will retry for Failed messages.CAP has the following retry  strategies:

**1、 Retry on sending**

in the process of sending a message,when the Broker crashed or connection failed or exceptions are thrown,CAP will retry,it will retry 3 times for the first time,if still failed,then it will retry every 1 minute,the retry the retry count +1,when the retry count come to 50,CAP will not retry any more.

>You can modify `FailedRetryCount` in `CapOptions` to change the default retry count.

As metioned above,when the retry count comes to a certain number,CAP will not retry anymore,this time,you can find out the fail reason in the Dashboard and they deal with it manually.

**2、 Retry on Consuming**

When consumer received messages,specified method in the consumer will be executed,if exceptions are thrown during this course,CAP will retry,the retry  strategy is the same as above `Retry on sending`.

## Data clean out

table to store messages in database has an `ExpiresAt` field to mark the expiration time of the message. CAP will set `ExpiresAt` value as **1 hour** for  `Successed` messages and **15days** for `Failed` messages.

To avoid performance slow down caused by a large amount of data,CAP will delete expired data every hour by default,the deletion rule is that `ExpiresAt` field's value isn't null and samller than current time.That is, `Failed` messages(it has been retried  50 times by default),if you do not deal with it manually,will also be deleted after 15 days as well,you have to pay attention to it.