# CAP
[![Travis branch](https://img.shields.io/travis/dotnetcore/CAP/master.svg?label=travis-ci)](https://travis-ci.org/dotnetcore/CAP)
[![AppVeyor](https://ci.appveyor.com/api/projects/status/4mpe0tbu7n126vyw?svg=true)](https://ci.appveyor.com/project/yuleyule66/cap)
[![NuGet](https://img.shields.io/nuget/vpre/DotNetCore.CAP.svg)](https://www.nuget.org/packages/DotNetCore.CAP/)
[![GitHub license](https://img.shields.io/badge/license-MIT-blue.svg)](https://raw.githubusercontent.com/dotnetcore/CAP/master/LICENSE.txt)

CAP һڷֲʽϵͳSOAMicroServiceʵһԵĿ⣬ʹáܵص㡣

## ԤOverView

CAP һ ASP.NET Core ĿʹõĿ⣬Ȼ ASP.NET Core On .NET Framework С

԰ CAP һ EventBusΪ EventBus йܣ CAP ṩ˸Ӽ򻯵ķʽ EventBus еķͶġ

CAP Ϣ־ûĹܣķ崻ʱԱ֤ϢĿɿԡCAPṩ˻Microsoft DI  Publisher Service Ժҵ޷ϣ֧ǿһԵ

CAPASP.NET Core ΢ܹеһʾͼ

![](http://images2015.cnblogs.com/blog/250417/201707/250417-20170705175827128-1203291469.png)

> ͼʵִ߲û룬ִ߲CAPڲʵ֡

## Getting Started

### NuGet 

Ŀаװ CAP

Ϣʹõ Kafka Ļԣ

```
PM> Install-Package DotNetCore.CAP.Kafka -Pre
```

Ϣʹõ RabbitMQ Ļԣ

```
PM> Install-Package DotNetCore.CAP.RabbitMQ -Pre
```

CAP Ĭṩ Entity Framwork Ϊݿ洢

```
PM> Install-Package DotNetCore.CAP.EntityFrameworkCore -Pre
```

### Configuration

CAP Startup.cs ļУ£

```cs
public void ConfigureServices(IServiceCollection services)
{
	......

    services.AddDbContext<AppDbContext>();

    services.AddCap()
            .AddEntityFrameworkStores<AppDbContext>()
            .AddKafka(x => x.Servers = "localhost:9092");
}

public void Configure(IApplicationBuilder app)
{
	.....

    app.UseCap();
}

```

### 

 Controller ע `ICapPublisher` Ȼʹ `ICapPublisher` Ϣ

```cs
public class PublishController : Controller
{
	private readonly ICapPublisher _publisher;

	public PublishController(ICapPublisher publisher)
	{
		_publisher = publisher;
	}


	[Route("~/checkAccount")]
	public async Task<IActionResult> PublishMessage()
	{
		//ָ͵Ϣͷ
		await _publisher.PublishAsync("xxx.services.account.check", new Person { Name = "Foo", Age = 11 });

		return Ok();
	}
}

```

### 

**Action Method**

 Action  CapSubscribeAttribute Ϣ

```cs
public class PublishController : Controller
{
	private readonly ICapPublisher _publisher;

	public PublishController(ICapPublisher publisher)
	{
		_publisher = publisher;
	}


	[NoAction]
	[CapSubscribe("xxx.services.account.check")]
	public async Task CheckReceivedMessage(Person person)
	{
		Console.WriteLine(person.Name);
		Console.WriteLine(person.Age);     
		return Task.CompletedTask;
	}
}

```

**Service Method**

Ķķûλ Controller У㶩ĵҪ̳ `ICapSubscribe`

```cs

namespace xxx.Service
{
	public interface ISubscriberService
	{
		public void CheckReceivedMessage(Person person);
	}


	public class SubscriberService: ISubscriberService, ICapSubscribe
	{
		[KafkaTopic("xxx.services.account.check")]
		public void CheckReceivedMessage(Person person)
		{
			
		}
	}
}

```

Ȼ Startup.cs е `ConfigureServices()` ע  `ISubscriberService` 

```cs
public void ConfigureServices(IServiceCollection services)
{
	services.AddTransient<ISubscriberService,SubscriberService>();
}
```

## 

׵򵥵ķ֮һǲۺ⣨issueҲͨύ Pull Request ס

### License

MIT
