﻿using System;
using System.Diagnostics;
using System.Threading.Tasks;
using Microsoft.Extensions.Logging;

namespace DotNetCore.CAP.Job
{
    public class InfiniteRetryProcessor : IJobProcessor
    {
        private readonly IJobProcessor _inner;
        private readonly ILogger _logger;

        public InfiniteRetryProcessor(
            IJobProcessor inner,
            ILoggerFactory loggerFactory)
        {
            _inner = inner;
            _logger = loggerFactory.CreateLogger<InfiniteRetryProcessor>();
        }

        public override string ToString() => _inner.ToString();

        public async Task ProcessAsync(ProcessingContext context)
        {
            while (!context.IsStopping)
            {
                Debug.WriteLine("InfiniteRetryProcessor在开线程：" + _inner.ToString() + "  :  " + DateTime.Now);
                try
                {
                    await _inner.ProcessAsync(context);
                }
                catch (OperationCanceledException)
                {
                    return;
                }
                catch (Exception ex)
                {
                    _logger.LogWarning(
                        1,
                        ex,
                        "Prcessor '{ProcessorName}' failed. Retrying...", _inner.ToString());
                }
            }
        }
    }
}