# Contributing to CleanArchitecture

**First:** if you're unsure or afraid of _anything_, just ask or submit the
issue or pull request anyways. You won't be yelled at for giving your best
effort. The worst that can happen is that you'll be politely asked to change
something. We appreciate any sort of contributions, and don't want a wall of
rules to get in the way of that.

However, for those individuals who want a bit more guidance on the best way to
contribute to the project, read on. This document will cover what we're looking
for. By addressing all the points we're looking for, it raises the chances we
can quickly merge or address your contributions.

## Issues

### Reporting an Issue

* Make sure you test against the latest released version. It is possible we
  already fixed the bug you're experiencing.
  
* If you can, check and see if there is an existing open issue that is already 
  reporting the problem. Feel free to upvote this issue or comment on it to 
  describe your specific scenario (assuming it's the same underlying issue).

* Provide a reproducible test case. If a contributor can't reproduce an issue,
  then it dramatically lowers the chances it'll get fixed. And in some cases,
  the issue will eventually be closed.

* Respond promptly to any questions made by the maintainers about your issue. Stale
  issues will be closed (eventually).

## Pull Requests

* Pull requests are welcome but are most likely to be accepted when they address
  an existing issue. A common workflow is to create an issue describing the problem
  your PR would solve, and then volunteer to submit a PR addressing the issue as an 
  initial comment on the issue.
  
* As much as possible, pull requests should follow the existing coding conventions
  used by the project. This is generally true for any project. The only exception to 
  this would be a pull request whose purpose is to adjust the coding conventions used
  by the project.
  
* When possible, issues will be marked with a `help wanted` tag if community contributions
  are particularly welcome for them. This will often be the case for relatively simple
  fixes that would make good initial contributions.
  
* If your PR addresses an issue, please include "Fixes #NNN" in the summary for the PR
  so that the issue is linked to the PR (and vice versa) and if/when the PR is merged,
  the issue is automatically closed.
  
Thank you for reading this and for considering contributing to this project!
  
