$(function () {

    var l = abp.localization.getResource('Stores');

    var service = easyAbp.eShop.stores.stores.store;
    var createModal = new abp.ModalManager(abp.appPath + 'EShop/Stores/Stores/Store/CreateModal');
    var editModal = new abp.ModalManager(abp.appPath + 'EShop/Stores/Stores/Store/EditModal');

    var dataTable = $('#StoreTable').DataTable(abp.libs.datatables.normalizeConfiguration({
        processing: true,
        serverSide: true,
        paging: true,
        searching: false,
        autoWidth: false,
        scrollCollapse: true,
        order: [[1, "asc"]],
        ajax: abp.libs.datatables.createAjax(service.getList),
        columnDefs: [
            {
                rowAction: {
                    items:
                        [
                            {
                                text: l('Edit'),
                                action: function (data) {
                                    editModal.open({ id: data.record.id });
                                }
                            },
                            {
                                text: l('Delete'),
                                confirmMessage: function (data) {
                                    return l('StoreDeletionConfirmationMessage', data.record.id);
                                },
                                action: function (data) {
                                    service.delete(data.record.id)
                                        .then(function () {
                                            abp.notify.info(l('SuccessfullyDeleted'));
                                            dataTable.ajax.reload();
                                        });
                                }
                            }
                        ]
                }
            },
            { data: "name" },
        ]
    }));

    createModal.onResult(function () {
        dataTable.ajax.reload();
    });

    editModal.onResult(function () {
        dataTable.ajax.reload();
    });

    $('#NewStoreButton').click(function (e) {
        e.preventDefault();
        createModal.open();
    });
});