using EasyAbp.EShop.Orders.Orders;
using Microsoft.Extensions.DependencyInjection;
using Volo.Abp.EntityFrameworkCore;
using Volo.Abp.Modularity;

namespace EasyAbp.EShop.Orders.EntityFrameworkCore
{
    [DependsOn(
        typeof(EShopOrdersDomainModule),
        typeof(AbpEntityFrameworkCoreModule)
    )]
    public class EShopOrdersEntityFrameworkCoreModule : AbpModule
    {
        public override void ConfigureServices(ServiceConfigurationContext context)
        {
            context.Services.AddAbpDbContext<OrdersDbContext>(options =>
            {
                /* Add custom repositories here. Example:
                 * options.AddRepository<Question, EfCoreQuestionRepository>();
                 */
                options.AddRepository<Order, OrderRepository>();
            });
        }
    }
}
